#version 430

layout (location = 0) in vec3 VertexPosition; // Stream of vertex positions 
layout (location = 1) in vec3 VertexNormal; // Stream of vertex normals 

layout (location=2) in ivec4 BoneIDs; // Stream of vertex bone IDs
layout (location=3) in vec4 Weights; // Stream of vertex weights

layout (location=4) in vec2 UVs;

const int MAX_BONES = 70; // Max number of bones
uniform mat4 gBones[MAX_BONES]; // Bone transformations 

out vec3 VertPos; //Vertex position in eye coords
out vec2 TexCoords;
out vec3 N; //Transformed normal

out vec4 ViewSpaceVertPos; // vertex pos in view coords

uniform mat4 M;
uniform mat4 MV;
uniform mat4 MVP;
uniform mat4 NormalMatrix;

void main()
{
	// Multiply each bone transformation by the particular weight
	// and combine them. 
   	mat4 BoneTransform = gBones[ BoneIDs[0] ] * Weights[0];
	BoneTransform += gBones[ BoneIDs[1] ] * Weights[1];
    BoneTransform += gBones[ BoneIDs[2] ] * Weights[2];
    BoneTransform += gBones[ BoneIDs[3] ] * Weights[3];

	// Transformed vertex position 
	vec4 tPos = BoneTransform * vec4(VertexPosition, 1.0);

	gl_Position = MVP * tPos;

	// Transformed normal 
	vec4 tNormal = BoneTransform * vec4(VertexNormal, 0.0);

	//mat3 NormMatrix = transpose(inverse(mat3(M)));

	N = normalize(NormalMatrix * tNormal).xyz;

    vec4 worldPos = M * tPos;

	VertPos = worldPos.xyz;  
	ViewSpaceVertPos = MV * (vec4(VertexPosition, 1.0));
	
	TexCoords = UVs;   
}